<?php
require_once __DIR__.'/../core/DB.php';
require_once __DIR__.'/../core/FieldManager.php';

$db = new DB();
$fieldManager = new FieldManager($db);

$postId = $_GET['id'] ?? 0;
$post = $db->query("SELECT * FROM posts WHERE id = ?", [$postId])->fetch();

if (!$post) {
    header("Location: index.php");
    exit;
}

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $title = trim($_POST['title']);
        if (empty($title)) throw new Exception("Title cannot be empty");

        // Slug handling - prioritize custom slug if provided
        $customSlug = trim($_POST['custom_slug'] ?? '');
        $slug = !empty($customSlug) ? $customSlug : $post['slug'];

        // Ensure slug uniqueness (excluding current post)
        $counter = 1;
        $originalSlug = $slug;
        while ($db->query("SELECT id FROM posts WHERE BINARY slug = ? AND id != ?", [$slug, $postId])->fetch()) {
            $slug = $originalSlug . '-' . $counter++;
        }

        // Dynamic field update
        $updates = ['title = ?', 'content = ?', 'slug = ?'];
        $params = [$title, $_POST['content'] ?? '', $slug];

        $columns = $db->query("SHOW COLUMNS FROM posts")->fetchAll();
        foreach ($columns as $col) {
            $field = $col['Field'];
            if (!in_array($field, ['id', 'created_at']) && isset($_POST[$field])) {
                $updates[] = "`$field` = ?";
                $params[] = $_POST[$field] === '' ? null : $_POST[$field];
            }
        }

        $params[] = $postId; // For WHERE clause
        $query = "UPDATE posts SET " . implode(', ', $updates) . " WHERE id = ?";
        $db->query($query, $params);

        header("Location: index.php?success=1");
        exit;
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

$columns = $db->query("SHOW COLUMNS FROM posts")->fetchAll();
$reservedColumns = ['id', 'created_at'];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Post</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        .field { margin-bottom: 1rem; }
        textarea { width: 100%; min-height: 100px; }
        .slug-field { background: #f0f0f0; padding: 10px; margin: 1rem 0; }
    </style>
</head>
<body>
<h1>Edit Post</h1>

<?php if (isset($error)): ?>
    <div style="color: red;"><?= $error ?></div>
<?php endif; ?>

<form method="POST">
    <?php foreach ($columns as $col): ?>
        <?php if (!in_array($col['Field'], $reservedColumns)): ?>
            <div class="field">
                <label><?= ucfirst($col['Field']) ?></label>
                <?php if (strpos($col['Type'], 'varchar') !== false || $col['Type'] === 'text'): ?>
                    <input type="text" name="<?= $col['Field'] ?>"
                           value="<?= htmlspecialchars($post[$col['Field']] ?? '') ?>">
                <?php elseif ($col['Type'] === 'longtext'): ?>
                    <textarea name="<?= $col['Field'] ?>"><?=
                        htmlspecialchars($post[$col['Field']] ?? '')
                        ?></textarea>
                <?php elseif ($col['Type'] === 'int'): ?>
                    <input type="number" name="<?= $col['Field'] ?>"
                           value="<?= htmlspecialchars($post[$col['Field']] ?? 0) ?>">
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <div class="slug-field">
        <label><strong>Custom URL Slug</strong></label>
        <input type="text" name="custom_slug"
               value="<?= htmlspecialchars($post['slug']) ?>"
               placeholder="Leave blank to keep current">
        <small>Current: <?= htmlspecialchars($post['slug']) ?></small>
    </div>

    <button type="submit">Update Post</button>
    <a href="index.php">Cancel</a>
</form>
</body>
</html>